﻿using System;
using System.Speech.Synthesis;

namespace Speech_Synthesis
{
    public partial class Window1 : System.Windows.Window
    {
        public Window1()
        {
            InitializeComponent();

            SpeechSynthesizer synthesizer = new SpeechSynthesizer();
            PromptBuilder promptBuilder = new PromptBuilder();

            promptBuilder.AppendTextWithHint("WPF", SayAs.SpellOut);
            promptBuilder.AppendText("brzmi lepiej niż WPF.");

            // Dwusekundowa pauza
            promptBuilder.AppendBreak(new TimeSpan(0, 0, 2));
            
            promptBuilder.AppendText("Jest godzina");
            promptBuilder.AppendTextWithHint(DateTime.Now.ToString("hh:mm"), SayAs.Time);

            // Dwusekundowa pauza
            promptBuilder.AppendBreak(new TimeSpan(0, 0, 2));

            promptBuilder.AppendText("Hej, Sam, czy potrafisz powiedzieć kolejka?");
            
            promptBuilder.StartVoice("Microsoft Sam");
            promptBuilder.AppendTextWithHint("kolejka", SayAs.SpellOut);
            promptBuilder.EndVoice();
            
            promptBuilder.AppendText("Szybciej!");
            
            promptBuilder.StartVoice("Microsoft Sam");
            promptBuilder.StartStyle(new PromptStyle(PromptRate.ExtraFast));
            promptBuilder.AppendTextWithHint("kolejka", SayAs.SpellOut);
            promptBuilder.EndStyle();
            promptBuilder.EndVoice();

            // Powiedz wszystko w PromptBuilder
            synthesizer.SpeakAsync(promptBuilder);
        }
    }
}